
******** DO FILE DESCRIPTION ************
***   This do file produces 
*** - descriptive stats (Table 7), 
*** - Appendix Figure A.1 
*** - Appendix Figure C8-C10.
*****************************************

set matsize 800
set more off
pause off
clear
set seed 1073741823
graph set window fontface "Times New Roman"
cd ""
global mainpath "/Users/ekurt/Desktop/MP ASYM/Stata"

cap log close
use "${mainpath}/Data/Quarter_LP_Ready3_REGS.dta",clear

drop if cyear < 1980

drop if cyear == 1980 & cquarter ==1
drop if cyear == 1980 & cquarter ==2

drop if cyear >= 2020

drop if DebtAssetRatio < 0 
drop if LiquidityRatio < 0 
drop if saleq < 0 
drop if invratio < 0 

xtset gvkeyn qdate
sort gvkeyn qdate

replace empC_ipo =empC_ipo*1000
replace invratio =. if cyear < 1986

egen firmtag = tag(gvkeyn)  // 14,209 firms
count if firmtag 


* ====================================
**** TABLE 7
* ====================================

* I. Summary Statistics, 
estpost tabstat empC_ipo invratio RealSales realasset DebtAssetRatio LiquidityRatio, statistic(N p5 median mean p95 sd) 
esttab . using "${mainpath}/Tables/Descriptive_2024_2.tex",  ///
cells("empC_ipo(fmt(1))  invratio(fmt(1)) RealSales(fmt(1)) realasset(fmt(1)) DebtAssetRatio(fmt(1)) LiquidityRatio(fmt(1))")  ///
label noobs replace title("Descriptive Statistics")   ///
collabels("Employees" "Investment Rate" "Sales" "Assets" "Debt to Assets" "Liquidity Ratio" )


* ====================================
**** APPENDIX FIGURE A.1
* ====================================

rename GK_New2019 Extracted_MPShockE 
replace Extracted_MPShockE = 0 if Extracted_MPShockE ==.

*TIME SERIES OF MP SHOCKS 
tsline Extracted_MPShockE, graphregion(color(white)) lcolor(black) ytitle("Monetary Policy Shocks", size(large)) ///
xtitle("Quarters", size(large)) ylabel(, labsize(large)) xlabel(, labsize(medlarge)) lwidth(medthick) yline(0, lcolor(gs12)) yscale(r(-10 6))
graph export "${mainpath}/Figures/Descriptive/MP Shocks_TS_FigA1.png", replace 

* ====================================
 
/* 
cap drop firmtag
egen firmtag = tag(gvkeyn) 
count if firmtag 

cap drop life 
cap drop maxlife
cap drop a
sort gvkeyn qdate
bys gvkeyn: gen maxlife = _N
bys gvkeyn: gen life = _n
gen a = maxlife if life == maxlife
*/

* ====================================
**** BELOW CODE PRODUCES APPENDIX FIGURE C.8, C.9 and C.10.
* ====================================

* ====================================
**** APPENDIX FIGURE C.8
* ====================================

capture macro drop nq
global nq = 4 

cap drop var1
gen var1 =  DebtAssetRatio 

sort gvkeyn qdate
capture drop lag_var1
cap drop rank_var
bysort gvkeyn: gen lag_var1 = var1
xtile rank_var = lag_var1, nq($nq)

capture label drop varlabel 

cap drop meanl*
bysort rank_var : egen meanlev = mean(DebtAssetRatio)
bysort rank_var : egen meanliq = mean(LiquidityRatio)

label var meanlev "Leverage Ratio"
label var meanliq "Liquidity Ratio"

global ncat = 2
cap drop *_rank2
gen high_rank2 = .
gen low_rank2 = .

replace high_rank2 = 1 if spcsrc == "A" | spcsrc == "A+" | spcsrc == "A-" | spcsrc == "B" | spcsrc == "B+"  
replace low_rank2 = 1 if spcsrc == "B-"| spcsrc == "C" | spcsrc == "D"  

cap drop sum_hrank2
bysort rank_var : egen sum_hrank2 = sum(high_rank2)
cap drop sum_lrank2
bysort rank_var : egen sum_lrank2 = sum(low_rank2)

label var sum_hrank "Rating A, A+, A-, B, B+," 
label var sum_lrank "Rating B-, C, D"

cap drop *_share2
gen high_share2 = .
gen low_share2 = .

cap drop nobs_rank
bys rank_var: gen nobs_rank = _N // total nr of obs per rank.

bysort rank_var : replace high_share2 = sum_hrank2/nobs_rank
bysort rank_var : replace low_share2 = sum_lrank2/nobs_rank


label var high_share2 "Share of ratings A, A+, A-, B, B+"
label var low_share2 "Share of ratings B-, C, D"

graph bar high_share2 low_share2 , over(rank_var)  legend(label(1 "High credit rating") label(2 "Low credit rating")) ///
bar(1, color(edkblue)) bar(2, color(olive_teal)) bar(3, color(sand)) ytitle("Share of ratings", size(large))  ///
graphregion(color(white)) yscale(r(0 0.5)) ylabel(0(0.1)0.5, labsize(large)) 
graph export "${mainpath}/Figures/Descriptive/lev_rating_${nq}_FigC8.png", replace


* ====================================
**** APPENDIX FIGURE C.9
* ====================================

capture macro drop nq
global nq = 4 

cap drop var1
gen var1 =   LiquidityRatio  

sort gvkeyn qdate
capture drop lag_var1
cap drop rank_var
bysort gvkeyn: gen lag_var1 = var1
xtile rank_var = lag_var1, nq($nq)

capture label drop varlabel 

cap drop meanl*
bysort rank_var : egen meanlev = mean(DebtAssetRatio)
bysort rank_var : egen meanliq = mean(LiquidityRatio)

label var meanlev "Leverage Ratio"
label var meanliq "Liquidity Ratio"

global ncat = 2
cap drop *_rank2
gen high_rank2 = .
gen low_rank2 = .

replace high_rank2 = 1 if spcsrc == "A" | spcsrc == "A+" | spcsrc == "A-" | spcsrc == "B" | spcsrc == "B+"  
replace low_rank2 = 1 if spcsrc == "B-"| spcsrc == "C" | spcsrc == "D"  

cap drop sum_hrank2
bysort rank_var : egen sum_hrank2 = sum(high_rank2)
cap drop sum_lrank2
bysort rank_var : egen sum_lrank2 = sum(low_rank2)

label var sum_hrank "Rating A, A+, A-, B, B+,"
label var sum_lrank "Rating B-, C, D"

cap drop *_share2
gen high_share2 = .
gen low_share2 = .

cap drop nobs_rank
bys rank_var: gen nobs_rank = _N 

bysort rank_var : replace high_share2 = sum_hrank2/nobs_rank
bysort rank_var : replace low_share2 = sum_lrank2/nobs_rank


label var high_share2 "Share of ratings A, A+, A-, B, B+"
label var low_share2 "Share of ratings B-, C, D"

graph bar high_share2 low_share2 , over(rank_var)  legend(label(1 "High credit rating") label(2 "Low credit rating")) ///
bar(1, color(edkblue)) bar(2, color(olive_teal)) bar(3, color(sand)) ytitle("Share of ratings", size(large))  ///
graphregion(color(white)) yscale(r(0 0.5)) ylabel(0(0.1)0.5, labsize(large)) 
graph export "${mainpath}/Figures/Descriptive/liq_rating_${nq}_FigC9.png", replace

* ====================================
**** APPENDIX FIGURE C.10
* ====================================

capture macro drop nq
global nq = 4 

cap drop var1
gen var1 =  realasset

sort gvkeyn qdate
capture drop lag_var1
cap drop rank_var
bysort gvkeyn: gen lag_var1 = var1
xtile rank_var = lag_var1, nq($nq)

capture label drop varlabel 

global ncat = 2
cap drop *_rank2
gen high_rank2 = .
gen low_rank2 = .

replace high_rank2 = 1 if spcsrc == "A" | spcsrc == "A+" | spcsrc == "A-" | spcsrc == "B" | spcsrc == "B+"  
replace low_rank2 = 1 if spcsrc == "B-"| spcsrc == "C" | spcsrc == "D"  

cap drop sum_hrank2
bysort rank_var : egen sum_hrank2 = sum(high_rank2)
cap drop sum_lrank2
bysort rank_var : egen sum_lrank2 = sum(low_rank2)

label var sum_hrank "Rating A, A+, A-, B, B+," 
label var sum_lrank "Rating B-, C, D"

cap drop *_share2
gen high_share2 = .
gen low_share2 = .

cap drop nobs_rank
bys rank_var: gen nobs_rank = _N // total nr of obs per rank.

bysort rank_var : replace high_share2 = sum_hrank2/nobs_rank
bysort rank_var : replace low_share2 = sum_lrank2/nobs_rank


label var high_share2 "Share of ratings A, A+, A-, B, B+"
label var low_share2 "Share of ratings B-, C, D"

graph bar high_share2 low_share2 , over(rank_var)  legend(label(1 "High credit rating") label(2 "Low credit rating")) ///
bar(1, color(edkblue)) bar(2, color(olive_teal)) bar(3, color(sand)) ytitle("Share of ratings", size(large))  ///
graphregion(color(white)) yscale(r(0 0.5)) ylabel(0(0.1)0.5, labsize(large)) 
graph export "${mainpath}/Figures/Descriptive/size_rating_${nq}_FigC10.png", replace



